﻿/*
 * Crée par SharpDevelop.
 * Utilisateur: Julien
 * Date: 09/02/2016
 * Heure: 15:12
 * 
 * Pour changer ce modèle utiliser Outils | Options | Codage | Editer les en-têtes standards.
 */
using System;
using WComp.Beans;

namespace WComp.Beans
{
	/// <summary>
	/// This is a sample bean, which has an integer evented property and a method.
	/// 
	/// Notes: for beans creating threads, the IThreadCreator interface should be implemented,
	/// 	providing a cleanup method should be implemented and named `Stop()'.
	/// For proxy beans, the IProxyBean interface should  be implemented,
	/// 	providing the IsConnected property, allowing the connection status to be drawn in
	/// 	the AddIn's graphical designer.
	/// 
	/// Several classes can be defined or used by a Bean, but only the class with the
	/// [Bean] attribute will be available in WComp. Its ports will be all public methods,
	/// events and properties definied in that class.
	/// </summary>
	[Bean(Category="StringToBool")]
	public class Bean1
	{
		/// <summary>
		/// Fill in private attributes here.
		/// </summary>
		private string property;

		/// <summary>
		/// This property will appear in bean's property panel and bean's input functions.
		/// </summary>
		public string MyProperty {
			get { return property; }
			set {
				property = value;
				if(property.Equals("True"))
				{
					FireBoolEvent(true);	
				}
				else{
					FireBoolEvent(false);	
				}
				// event will be fired for every property set.
			}
		}

		/// <summary>
		/// Here are the delegate and his event.
		/// A function checking nullity should be used to fire events (like FireIntEvent).
		/// </summary>
		public delegate void BoolValueEventHandler(bool val);
		/// <summary>
		/// the following declaration is the event by itself. Its name, here "PropertyChanged",
		/// is the name of the event as it will be displayed in the bean type's interface.
		/// </summary>
		public event BoolValueEventHandler PropertyChanged;
		
		private void FireBoolEvent(bool i) {
			if (PropertyChanged != null)
				PropertyChanged(i);
		}
	}
}
